//basic IO setup and defines

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
//using some backpack definitions
#include "backpack.h"

//pinout for PIC16F18146 Multi-channel volume master
//2     RA5 CS_3
//3     RA4 CS_1
//5     RC5 LEDCON
//6     RC4 CS_2
//7     RC3 SHDN_DP
//8     RC6 LCD_CS
//9     RC7 MOSI (HW)
//10    RB7 LCD_DC
//11    RB6 SCK (HW)
//12    RB5 TOUCH_CS
//13    RB4 MISO (HW)
//14    RC2 IR_RX
//15    RC1 CS_5
//16    RC0 CS_4
//17    RA2 LCD_RST

#define CS_1 a4
#define CS_2 c4
#define CS_3 a5
#define CS_4 c0
#define CS_5 c1
#define SHDN_DP c3

void ioinit(void);
void tmr2init(void);          //sets up a tick
void sendDP(unsigned char chan, unsigned char val);   //maps channels to CS

#endif	/* IO_H */

